/*global define */
/*jslint white: true */

/*
	EventGraphPileItem:

	This object defines the event graph pile item, which represents a referenced to a event recording file.
*/

define(["src/utils", "src/build/treeLeaf", "src/build/TimeItem", "src/math/mathUtils"],
function(utils, treeLeaf, TimeItem, mathUtils) {
	"use strict";

	var TimeItem_clone = TimeItem.prototype.clone;
	
	function EventGraphPileItem(inEnabled, inSolo, inBlendEnvelope, inBoundBehaviorId, inBoundInstanceId, 
								 	inParamId, inTakeGroupId0, inFilePath, inEditedKeyframeBuckets) {
		this.TimeItem("TimeItem");

		// do not modify these private members directly or notifiers won't be called correctly
		this.pPileItem = { 
			parent					: undefined,
			enabledB				: inEnabled,
			soloB					: inSolo,
		    blendEnvelope			: inBlendEnvelope,
			boundBehaviorId			: inBoundBehaviorId,
			boundInstanceId 		: inBoundInstanceId,
			paramId					: inParamId,
			takeGroupId0			: inTakeGroupId0,
			filePath				: inFilePath,
			editedKeyframeBuckets 	: inEditedKeyframeBuckets
		};
	}
	
	// static function 
	function formulateEventGraphParamAndTakeGroupId (inParamId, inTakeGroupId0) {
		if (inTakeGroupId0) {
			return inParamId + "/" + inTakeGroupId0;
		}
		return inParamId;
	}
	
	// Should this be marked static with a prefix?  -jacquave
	EventGraphPileItem.formulateEventGraphParamAndTakeGroupId = formulateEventGraphParamAndTakeGroupId;

	utils.mixin(EventGraphPileItem, TimeItem,
		treeLeaf({ 
			parentLabel   : "parent", 
			getTreeInfo : function (obj) { return obj.pPileItem; }		
		}),

		{
			isEnabled : function () {
				return this.pPileItem.enabledB;
			},

			isSolo : function () {
				return this.pPileItem.soloB;
			},

			getBoundBehaviorId : function () {
				return this.pPileItem.boundBehaviorId;
			},

			getBoundInstanceId : function () {
				return this.pPileItem.boundInstanceId;
			},
		
			getParamId : function () {
				return this.pPileItem.paramId;
			},

			getTakeGroupId : function () {
				return this.pPileItem.takeGroupId0;
			},

			getParamAndTakeGroupId : function () {
				return formulateEventGraphParamAndTakeGroupId(this.getParamId(), this.getTakeGroupId());
			},

			getFilePath : function () {
				return this.pPileItem.filePath;
			},

			getEditedKeyframeBuckets : function () {
				return this.pPileItem.editedKeyframeBuckets;
			},

			getBlendWeight : function (time) {
				if (this.isActivateAtTime(time)) {
					var w = 1.0;
					
					if (this.pPileItem.blendEnvelope) {
						var dIn = time - this.getTrimInTime(),
							dOut = this.getTrimOutTime() - time;
						if (this.pPileItem.blendEnvelope._fadeInDuration && dIn >= 0 && dIn <= this.pPileItem.blendEnvelope._fadeInDuration) {
							w = w * mathUtils.easeInAndOut(dIn / this.pPileItem.blendEnvelope._fadeInDuration);
						}
						if (this.pPileItem.blendEnvelope._fadeOutDuration && dOut >= 0 && dOut <= this.pPileItem.blendEnvelope._fadeOutDuration) {
							w = w * mathUtils.easeInAndOut(dOut / this.pPileItem.blendEnvelope._fadeOutDuration);
						}
					}
					return w;
				}
				return 0.0;
			},

			clone : function (clone_children, other) {
				var result = other;

				if (result) {
					// init
					EventGraphPileItem.call(result);
				} else {
					// alloc and init
					result = new EventGraphPileItem();
				}

				// clone time item state
				TimeItem_clone.call(this, clone_children, result);

				utils.clone(false, result.pPileItem, this.pPileItem);

				delete result.pPileItem.parent;
				result.setParent(undefined);

				return result;
			}
		});


	return EventGraphPileItem;
});
